//	Draw4DHelpIdeasView.swift
//
//	© 2025 by Jeff Weeks
//	See TermsOfUse.txt

import SwiftUI


let helpIdeasHeaderColor = Color(.displayP3, red: 0.00, green: 0.75, blue: 0.50, opacity: 1.0)

struct PageTitle: ViewModifier {
	func body(content: Content) -> some View {
		content
			.font(.title)
			.foregroundStyle(helpIdeasHeaderColor)
			.frame(maxWidth: .infinity, alignment: .center)
			.padding(EdgeInsets(top: 0.0, leading: 0.0, bottom: 0.0, trailing: 0.0))
	}
}

struct ExerciseTitle: ViewModifier {
	func body(content: Content) -> some View {
		content
			.multilineTextAlignment(.center)
			.font(.title3)
			.foregroundStyle(helpIdeasHeaderColor)
			.frame(maxWidth: .infinity, alignment: .center)
			.padding(EdgeInsets(top: 12.0, leading: 0, bottom: 4.0, trailing: 0))
	}
}

struct ExerciseContent: ViewModifier {
	func body(content: Content) -> some View {
		content
			.font(.body)
			.padding(EdgeInsets(top: 4.0, leading: 0, bottom: 4.0, trailing: 0))
	}
}

struct ExerciseFigure: ViewModifier {
	func body(content: Content) -> some View {
		content
			.frame(maxWidth: .infinity, alignment: .center)
	}
}


struct Draw4DHelpIdeasView: View {

	@State var modifiedBackgroundColor = Color("Modified Background Color")

	var body: some View {

		ScrollView {
			VStack(alignment: .leading, spacing: 0) {

				Text("Construction Ideas")
					.modifier(PageTitle())

				Group {
					Text("5-cell title")
						.modifier(ExerciseTitle())
					Text("5-cell text")
						.modifier(ExerciseContent())
				}

				Group {
					Text("16-cell title")
						.modifier(ExerciseTitle())
					Text("16-cell text 1")
						.modifier(ExerciseContent())
					Text("16-cell text 2")
						.modifier(ExerciseContent())
				}
					
				Group {
					Text("8-cell title")
						.modifier(ExerciseTitle())
					Text("8-cell text 1")
						.modifier(ExerciseContent())
					Text("8-cell text 2")
						.modifier(ExerciseContent())
					Text("8-cell text 3")
						.modifier(ExerciseContent())
				}

				Group {
					Text("AltVert title")
						.modifier(ExerciseTitle())
					Text("AltVert text 1")
						.modifier(ExerciseContent())
					Text("AltVert text 2")
						.modifier(ExerciseContent())
					Text("AltVert text 3")
						.modifier(ExerciseContent())
					Text("AltVert text 4")
						.modifier(ExerciseContent())
					Text("AltVert text 5")
						.modifier(ExerciseContent())
				}

				Group {
					Text("Diag title")
						.modifier(ExerciseTitle())
					Text("Diag text 1")
						.modifier(ExerciseContent())
					Image("Exercises/diagonal slice/3D cube plain")
						.modifier(ExerciseFigure())
					Text("Diag text 2")
						.modifier(ExerciseContent())
					Image("Exercises/diagonal slice/3D cube with slice")
						.modifier(ExerciseFigure())
					Text("Diag text 3")
						.modifier(ExerciseContent())
					Text("Diag text 4")
						.modifier(ExerciseContent())
				}

				Group {
					Text("Checker title")
						.modifier(ExerciseTitle())
					Text("Checker text 1")
						.modifier(ExerciseContent())
					Image("Exercises/fused checkerboard/2D image A")
						.modifier(ExerciseFigure())
					Text("Checker text 2")
						.modifier(ExerciseContent())
					Image("Exercises/fused checkerboard/2D image B")
						.modifier(ExerciseFigure())
					Text("Checker text 3")
						.modifier(ExerciseContent())
					Image("Exercises/fused checkerboard/2D image C")
						.modifier(ExerciseFigure())
					Text("Checker text 4")
						.modifier(ExerciseContent())
					Text("Checker text 5")
						.modifier(ExerciseContent())
					Text("Checker text 6")
						.modifier(ExerciseContent())
				}
			}
		}
		.padding(geometryGamesPanelPadding)
		.background(modifiedBackgroundColor)
		.cornerRadius(geometryGamesCornerRadius)
		.frame(width: 320.0, height: 480.0)
	}
}
